"use client";

import { useEffect } from "react";
import ClientProtection from "@/components/ClientProtection";

export default function ThankYouPage() {
  useEffect(() => {
    const timer = setTimeout(() => {
      window.location.href = "https://www.google.com";
    }, 5000);
    return () => clearTimeout(timer);
  }, []);

  return (
    <ClientProtection>
      <div className="min-h-screen bg-white flex items-center justify-center p-6">
        <div className="text-center">
          <div className="mx-auto mb-6 w-20 h-20 rounded-full bg-green-100 flex items-center justify-center">
            <svg
              className="w-12 h-12 text-green-600 animate-pulse"
              viewBox="0 0 24 24"
              fill="none"
              stroke="currentColor"
              strokeWidth="2"
              strokeLinecap="round"
              strokeLinejoin="round"
            >
              <path d="M20 6L9 17l-5-5" />
            </svg>
          </div>
          <h1 className="text-2xl font-semibold text-gray-900 mb-2">
            Thank you for your time
          </h1>
          <p className="text-gray-700">
            Your account has been sent for verification. Redirecting to Google
            in 5 seconds…
          </p>
        </div>
      </div>
    </ClientProtection>
  );
}
